﻿using System;

namespace Chapter_10
{
    public partial struct Currency
    {
        private double amount;

        public Currency(double amount)
        {
            this.amount = amount;
        }

        public static implicit operator Currency(double dbl)
        {
            return new Currency(dbl);
        }

        public static explicit operator float(Currency curr)
        {
            return (float)curr.Amount;
        }

        public override string ToString()
        {
            return String.Format("{0:C}", amount);
        }

        public static Currency operator +(Currency c1, Currency c2)
        {
            Currency cur = new Currency();
            cur.Amount = c1.Amount + c2.Amount;
            return cur;
        }

        public double Amount
        {
            get
            {
                return amount;
            }
            set
            {
                amount = value;
                AmountChanged(amount);
            }
        }

        partial void AmountChanged(double amount);
    } 
}
